/*****
 *       Mean value calculation example
 *                                                                   
 *  Copyright (C) 2015 Henrik Sandklef 
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/

/**
 * @file math.h
 * @author Henrik Sandklef
 * @date 25 Nov 2015
 * @brief Functions for mean value calculation
 *
 */

/**
 * @brief Given an 'array' of integers, this function calculates the mean value.
 *
 *
 * @param int *p - 'array' with integers to calc mean from
 * @param int size - size of 'array'
 * @param int *mean_value - a pointer to an integer where the function will store the mean value.
 * 
 * @return @c Error code. 0 - on success. 
 */
/* New version:
 int mean_value(int *p, int size, int *mean_value);
*/
int mean_value(int *p, int size);
